CREATE DATABASE PrzepisyPrzyklad
GO

USE PrzepisyPrzyklad
GO

CREATE TABLE Kategorie_skladnikow (
	IDKategoriiSkladnika smallint NOT NULL ,
	OpisKategoriiSkladnika nvarchar (255) NULL 
)
GO

CREATE TABLE Skladniki (
	IDSkladnika int NOT NULL ,
	NazwaSkladnika nvarchar (255) NULL ,
	IDKategoriiSkladnika smallint NULL ,
	IDMiaryIlosci smallint NULL 
)
GO

CREATE TABLE Miary (
	IDMiaryIlosci smallint NOT NULL ,
	OpisMiary nvarchar (255) NULL 
)
GO

CREATE TABLE Kategorie_przepisow (
	IDKategoriiPrzepisu smallint NOT NULL ,
	OpisKategoriiPrzepisu nvarchar (255) NULL 
)
GO

CREATE TABLE Skladniki_przepisow (
	IDPrzepisu int NOT NULL ,
	NumerKrokuPrzepisu smallint NOT NULL ,
	IDSkladnika int NULL ,
	IDMiaryIlosci smallint NULL ,
	Ilosc real NULL ,
)
GO

CREATE TABLE Przepisy (
	IDPrzepisu int NOT NULL ,
	NazwaPrzepisu nvarchar (255) NULL ,
	IDKategoriiPrzepisu smallint NULL ,
	SposobPrzyrzadzania ntext NULL ,
	Uwagi ntext NULL ,
) 
GO

ALTER TABLE Kategorie_skladnikow ADD 
	CONSTRAINT ID_kategorii_skladnika_domyslny DEFAULT (0) FOR IDKategoriiSkladnika,
	CONSTRAINT Kategorie_skladnikow_PK PRIMARY KEY   
	(
		IDKategoriiSkladnika
	)  
GO

ALTER TABLE Skladniki ADD 
	CONSTRAINT ID_skladnika_domyslny DEFAULT (0) FOR IDSkladnika,
	CONSTRAINT IN_ID_kategorii_skladnika_domyslny DEFAULT (0) FOR IDKategoriiSkladnika,
	CONSTRAINT IN_ID_miary_ilosci_domyslny DEFAULT (0) FOR IDMiaryIlosci,
	CONSTRAINT Skladniki_PK PRIMARY KEY   
	(
		IDSkladnika
	)  
GO

 CREATE  INDEX Kategorie_skladnikowSkladniki ON Skladniki(IDKategoriiSkladnika)
GO

 CREATE  INDEX MiarySkladniki ON Skladniki(IDMiaryIlosci)
GO

ALTER TABLE Miary ADD 
	CONSTRAINT ID_miary_domyslny DEFAULT (0) FOR IDMiaryIlosci,
	CONSTRAINT Miary_PK PRIMARY KEY   
	(
		IDMiaryIlosci
	)  
GO

ALTER TABLE Kategorie_przepisow ADD 
	CONSTRAINT ID_kategorii_przepisu_domyslny DEFAULT (0) FOR IDKategoriiPrzepisu,
	CONSTRAINT Kategorie_przepisow_PK PRIMARY KEY   
	(
		IDKategoriiPrzepisu
	)  
GO

ALTER TABLE Skladniki_przepisow ADD 
	CONSTRAINT RI_ID_przepisu_domyslny DEFAULT (0) FOR IDPrzepisu,
	CONSTRAINT Numer_kroku_przepisu_domyslny DEFAULT (0) FOR NumerKrokuPrzepisu,
	CONSTRAINT RI_ID_skladnika_domyslny DEFAULT (0) FOR IDSkladnika,
	CONSTRAINT RI_ID_miary_ilosci_domyslny DEFAULT (0) FOR IDMiaryIlosci,
	CONSTRAINT Ilosc_domyslny DEFAULT (0) FOR Ilosc,
	CONSTRAINT Skladniki_przepisow_PK PRIMARY KEY   
	(
		IDPrzepisu,
		NumerKrokuPrzepisu
	)  
GO

 CREATE  INDEX IDSkladnika ON Skladniki_przepisow(IDSkladnika)
GO

 CREATE  INDEX IDMiaryIlosci ON Skladniki_przepisow(IDMiaryIlosci)
GO

 CREATE  INDEX IDPrzepisu ON Skladniki_przepisow(IDPrzepisu)
GO

ALTER TABLE Przepisy ADD 
	CONSTRAINT ID_przepisu_domyslny DEFAULT (0) FOR IDPrzepisu,
	CONSTRAINT R_ID_kategorii_przepisu_domyslny DEFAULT (0) FOR IDKategoriiPrzepisu,
	CONSTRAINT Przepisy_PK PRIMARY KEY   
	(
		IDPrzepisu
	)  
GO

 CREATE  INDEX Kategorie_przepisowPrzepisy ON Przepisy(IDKategoriiPrzepisu)
GO

ALTER TABLE Skladniki ADD 
	CONSTRAINT Skladniki_FK00 FOREIGN KEY 
	(
		IDKategoriiSkladnika
	) REFERENCES Kategorie_skladnikow (
		IDKategoriiSkladnika
	) ON UPDATE CASCADE ,
	CONSTRAINT Skladniki_FK01 FOREIGN KEY 
	(
		IDMiaryIlosci
	) REFERENCES Miary (
		IDMiaryIlosci
	) ON UPDATE CASCADE
GO

ALTER TABLE Przepisy ADD 
	CONSTRAINT Przepisy_FK00 FOREIGN KEY 
	(
		IDKategoriiPrzepisu
	) REFERENCES Kategorie_przepisow (
		IDKategoriiPrzepisu
	) ON UPDATE CASCADE 
GO

ALTER Table Skladniki_przepisow ADD
	CONSTRAINT Skladniki_przepisow_FK00 FOREIGN KEY
	(
		IDPrzepisu
	) REFERENCES Przepisy (
		IDPrzepisu
	),
	CONSTRAINT Skladniki_przepisow_FK01 FOREIGN KEY
	(
		IDSkladnika
	) REFERENCES Skladniki (
		IDSkladnika
	),
	CONSTRAINT Skladniki_przepisow_FK02 FOREIGN KEY
	(
		IDMiaryIlosci
	) REFERENCES Miary (
		IDMiaryIlosci
	)
GO

